/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_PWM1.Prj
* File Name          : PWM1_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:16M/4T,WDT-Disable-288ms,RST-IO,BOR 2.4V 
*说明：本范例使用PWM1输出1KHz占空比为50%的方波,前后死区均为15us
*方波循环开启100ms,关闭100ms
*PWM10复用口为B0
*PWM11复用口为B1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void PWM1_Work(void)
{
	PWM10OE = 1;
	PWM11OE = 1;
	Delay_100ms();
	PWM10OE = 0;
	PWM11OE = 0;
	Delay_100ms();
}
//===============================================================================
//*********************************延时100ms*************************************
//延时100ms/4T下
//===============================================================================
void Delay_100ms(void)
{
	u8	R_Delay_Count,R_Delay_Count_1,R_Delay_Count_2;
	for(R_Delay_Count = 3;R_Delay_Count > 0;R_Delay_Count --)
	{
		for(R_Delay_Count_1 = 172;R_Delay_Count_1 > 0;R_Delay_Count_1 --)
		{
			for(R_Delay_Count_2 = 190;R_Delay_Count_2 > 0;R_Delay_Count_2 --);
		}
	}
}
//===============================================================================
//*********************************PWM1初始化************************************
//TC1设置：16位模式，16M，高频系统时钟，1:16分频
//PWM1配置，互补输出，前后死区均为15us
//===============================================================================
void PWM1_INIT(void)
{
//1、PWM1输出口设置
//PWM10复用口为B0
//PWM10复用口为B1
	MPPWM10 = 0x10;
	MPPWM11 = 0x11;
//2、TC1设置	
	T1CR = 0x0C;
	TC1CL = 0;
	TC1CH = 0;
	TC1PRL = 0xE7;
	TC1PRH = 0x03;
	TC1EN = 1;
//3、PWM1设置 
	PWM1CR = 0xB6;	
	PWM10DH = 0X01;
	PWM10DL = 0xF4;
//4、死区设置
	PWM11DH = 0x0F;
	PWM11DL = 0x0F;
}
/*********************************END OF FILE************************************/