/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F6820_SPI_Master.prj
* File Name          : SPI_MASTER_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：端口SSN(IOB5)、SCK(IOB46)、SDO(IOB3)、SDI(IOB2)
*主机向从机发送0x00-0x0F，接收从机发送的数据存放在R_SPI_MASTER_RecData.
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "COMMON.H"
//=============================================================================
//******************************SPI主机处理程序********************************
//SPI主机处理:主机向从机发送0x00-0x0F
//=============================================================================
void SPI_Master_Work(void)
{
	for(R_SPI_M_SEND_DATA = 0;R_SPI_M_SEND_DATA < 16;R_SPI_M_SEND_DATA++)
	{
		R_SPI_MASTER_RecData = SPI_Send(R_SPI_M_SEND_DATA);
	}
}
//===============================================================================
//****************************SPI发送并接收数据函数******************************
//发送并接收数据,并等待直到传输完成或写冲突
//该范例使用的是第一个时钟沿采样，第一个时钟沿采样是必须在每次传输数据完成前前将
//SSN保持低电平，传输完成后设置成高电平
//===============================================================================
unsigned char SPI_Send(unsigned char R_Data)
{
	IOB5 = 0;								//在数据传输完成前SSN保持低电平状态
	SPIDATA = R_Data;
	while(!SPIF);
	R_SPI_MASTER_DATA = SPIDATA;
	IOB5 = 1;
	return(SPIDATA);
}
//=============================================================================
//*******************************SPI主机初始化*********************************
//端口设置：发送口设置为输出模式，接收口设置为输入模式
//SPI主机设置：作为主机，MSB优先，需要片选信号
//=============================================================================
void SPI_Master_INIT(void)
{
//1、端口设置
	OEB5 = 1;			//SSN
	IOB5 = 1;
	OEB4 = 1;			//SCK
	OEB3 = 1;			//SDO
	OEB2 = 0;			//SDI
	ANSB2 = 0;
	ANSB3 = 0;
	ANSB4 = 0;
	ANSB5 = 0;
//2、SPI设置
	SPICR = 0XF0;
}

//*********************************END OF FILE***********************************