/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F6820_SPI_Slave.prj
* File Name          : SPI_SLAVER_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性 
*说明：端口SSN(IOB5)、SCK(IOB4)、SDO(IOB3)、SDI(IOB2)，
*从机接收到数据并发给主机
*接收主机发送的数据存在R_SPI_S_RECDATA
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************SPI从机处理***********************************
//SPI从机处理:从机从主机接收到数据并发给主机
//发生模式错误IOB0置1
//===============================================================================
void SPI_SLAVER_Work(void)
{
	if(B_SPI_Slave_State_Flag == 1)			//发生模式错误
	{
		B_SPI_Slave_State_Flag = 0;
		IOB0 = 1;
	}
	if(B_SPI_RecOK_Flag == 1)				//数据传输完成
	{
		B_SPI_RecOK_Flag = 0;
		SPIDATA = R_SPI_S_RECDATA;			//将从主机接收到的数据再发给主机
	}
}

//===============================================================================
//********************************SPI从机中断处理函数****************************
//SPI从机中断处理函数
//判断是是否传输完成，并将接收到的数据保存进R_SPI_S_RECDATA中
//===============================================================================
void SPI_S_Interrupt(void)
{
	if(SPIIE == 1)							//防止主机程序进入中断
	{
		if(SPIF2 == 1)
		{
			if(SPIF == 1)					//数据传输完成
			{
				B_SPI_RecOK_Flag = 1;
				R_SPI_S_RECDATA = SPIDATA;	//读接收到的数据
			}
			if(MODF == 1)					//发生模式错误
			{
				B_SPI_Slave_State_Flag = 1;
			}
		}
	}
}

//=============================================================================
//*******************************SPI从机初始化**********************************
//端口设置：发送口设置为输出模式，接收口设置为输入模式
//启用SPI通讯，片选信号来自于SSx端口
//开启I2C/SPI中断和总中断
//=============================================================================
void SPI_Slave_INIT(void)
{
//1、端口设置
	OEB5 = 0;				//SS0
	OEB4 = 0;				//SCK0
	OEB3 = 1;				//SDO0
	OEB2 = 0;				//SDI0
	ANSB2 = 0;
	ANSB3 = 0;
	ANSB4 = 0;
	ANSB5 = 0;
//2、SPI设置
	SPICR = 0XE0;
//3、高优先级中断设置
	SPIF2 = 0;
	SPIIE = 1;
	SPIP = 0;
	GIEH = 1;
}

//*********************************END OF FILE**********************************