/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_TC0.Prj
* File Name          : TC0_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例用TC0做定时器，每1ms翻转一次IOB1口
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************TC0初始化*************************************
//TC0设置：8位模式，16M，高频系统时钟，1:64分频
//t =计数/（时钟/分频）     1ms = （249+1）/（16/64）
//开启TC0溢出中断和总中断
//===============================================================================
void TC0_INIT(void)
{
//1、TC0设置
    T0CR =0x2E; 			
    TC0CH = 0;				
    TC0CL = 0;				
	TC0CL = 249;
	TC0EN = 1;
//2、高优先级中断设置 
	TC0IE = 1;
	TC0IF = 0;
	TC0IP = 0;
	GIEH = 1;
}

//===============================================================================
//*********************************TC0处理程序***********************************
//TC0处理:主循环TC0中断标志置1,每1ms翻转一次IOB1口
//===============================================================================
void TC0_Work(void)
{
	if(b_TC0_Flag == 1)
	{
		b_TC0_Flag = 0;
		IOB1 = ~IOB1;
	}	
}

//===============================================================================
//******************************TC0中断处理函数**********************************
//定时器TC0每计数1ms，进一次中断，标志位置高
//===============================================================================
void TC0_Interrupt (void)				
{
	if(TC0IF)
	{				
		TC0IF = 0;	
		b_TC0_Flag = 1;	
	}
}

/*********************************END OF FILE************************************/