/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_TC2G.Prj
* File Name          : TC2G_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例是TC2以TC0(1ms定时)门控模式为上升沿到上升沿
*当TC0第二次上升沿TC2G产生中断(2ms)并翻转IOB1口
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*******************************TC2G处理程序************************************
//主循环每次标志位为高时反转IOB1
//===============================================================================
void TC2G_Work(void)
{
	if(b_TC2_Flag == 1)
	{
		b_TC2_Flag = 0;
		IOB1 = ~IOB1;
	}
}

//===============================================================================
//*****************************TC2G中断处理函数**********************************
//定时器TC2G每触发一次，进一次中断，标志位置高
//===============================================================================
void TC2G_Interrupt (void)				
{
	if(TC2GIF)
	{					
		TC2GIF = 0;
		b_TC2_Flag = 1;
		TC2GO = 1;		
	}
}
//===============================================================================
//*********************************TC2G初始化*************************************
//TC0设置：8位模式，16M，高频系统时钟，1:64分频
//TC2门控——TC0溢出周期,用于测试TC0定时脉宽
//开启TC2溢出中断和总中断
//===============================================================================
void TC2G_INIT(void)
{
//1、TC0设置
    T0CR = 0x02E; 			
    TC0CH = 0;				
    TC0CL = 249;				
	TC0EN = 1;
//2、TC2门控设置	
	T2CR = 0X0C;
	TC2GCR = 0x86;
	TC2CL = 0;
	TC2CH = 0;
	TC2EN = 1;
	TC2GO = 1;
//3、高优先级中断设置 
	TC2GIF = 0;				
	TC2GIE = 1;	
	TC2GIP = 0;
	GIEH = 1;				
}
/*********************************END OF FILE************************************/