/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_Usart0.Prj
* File Name          : Usart0_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为异步串口通讯，串口每100ms发送一个字节数据，串口波特率为9600
*中断接收数据放在R_Receive_Data寄存器中
*串口接收错误数据放在R_Receive_Data_Err寄存器中
*串口端口有复用功能，TX端口为IOB0，RX端口为IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************Usart0处理*************************************
//Usart0处理:串口选择Hex,发送数据
//发送串口接受到的程序
//===============================================================================
void Usart0_Work(void)
{
	Delay_100ms();
	Usart_Send_Byte(R_Receive_Data);
}
//===============================================================================
//**************************延时处理函数*****************************************
//延时100ms/4T下
//===============================================================================
void Delay_100ms(void)
{
	u8	R_Delay_Count,R_Delay_Count_1,R_Delay_Count_2;
	for(R_Delay_Count = 3;R_Delay_Count > 0;R_Delay_Count --)
	{
		for(R_Delay_Count_1 = 172;R_Delay_Count_1 > 0;R_Delay_Count_1 --)
		{
			for(R_Delay_Count_2 = 190;R_Delay_Count_2 > 0;R_Delay_Count_2 --);
		}
	}
}
//===============================================================================
//***************************Usart_Send处理函数**********************************
//发送一个8位数据
//===============================================================================
void Usart_Send_Byte(unsigned char Data)
{
	TX0REG = Data;
	while(!T0MCLR);
}
//===============================================================================
//********************************Usart0初始化***********************************
//Usart0异步发送和接收设置
//开启异步接收中断,16分频,波特率为9600
//发送数据为8位，TX复用口为IOB0，RX复用口为IOB1
//===============================================================================
void Usart_INIT(void)
{
//1、设置Usart0复用口
//TX复用口为IOB0
//RX复用口为IOB1
	MPTX0 = 0x10;
	MPRX0 = 0x11;
	ANSB0 = 0;
	ANSB1 = 0;	
	OEB0 = 1;
	OEB1 = 0;
//2、Usart发送设置
	TX0CR = 0x82;
//3、波特率设置
	BRGD0H = 0x00;
	BRGD0L = 0x67;
//4、Usart接收设置
	RX0CR = 0x80;
//5、中断设置
	RX0IF = 0;
	RX0IE = 1;
	RX0IP = 0;
	GIEH = 1;					
}
/*********************************END OF FILE************************************/