/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_Usart1.Prj
* File Name          : M9F6820_Usart1.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*说明：本范例为异步串口通讯，串口波特率为9600
*中断接收数据放在R_Receive_Data寄存器中,
*串口接收错误数据放在R_Receive_Data_Err寄存器中
*串口每100ms发送接收到的数据
*串口端口有复用功能，TX端口为IOB0，RX端口为IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  			//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	Usart_INIT();				   	  		//Usart初始化
	while(1) 
	{
		CLRWDT();					  		//清除看门狗
		Delay_100ms();
		Usart_Send_Byte(R_Receive_Data);	
	}
}
//===============================================================================
//******************************高优先级中断服务子程序***************************
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	/*
		高优先级中断处理子函数
	*/
	Receive_Interrupt();
}
//===============================================================================
//******************************低优先级中断服务子程序***************************
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)		
{
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//**************************延时处理函数*****************************************
//延时100ms/4T下
//===============================================================================
void Delay_100ms(void)
{
	u8	R_Delay_Count,R_Delay_Count_1,R_Delay_Count_2;
	for(R_Delay_Count = 3;R_Delay_Count > 0;R_Delay_Count --)
	{
		for(R_Delay_Count_1 = 172;R_Delay_Count_1 > 0;R_Delay_Count_1 --)
		{
			for(R_Delay_Count_2 = 190;R_Delay_Count_2 > 0;R_Delay_Count_2 --);
		}
	}
}
//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               				//0:数字口	1:模拟口 
	PUA = 0x00;                				//0:上拉关闭 1:上拉使能
	PDA = 0x00;				   				//0:下拉关闭 1:下拉使能
	IOA = 0x00;               	 			//IO口数据
	OEA = 0xFF;                				//0:输入 1:输出
	//IOB
	ANSB = 0x00;
	PUB = 0x00;
	PDB = 0x00;
	IOB = 0x00;
	OEB = 0xFF;
	//IOC
	ANSC = 0x00;
	PUC = 0x00;
	PDC = 0x00;
	IOC = 0x00;
	OEC = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  				//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  				//1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/