/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_Usart1.Prj
* File Name          : Usart1_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为异步串口通讯，串口波特率为9600
*中断接收数据放在R_Receive_Data寄存器中
*串口接收错误数据放在R_Receive_Data_Err寄存器中
*串口端口有复用功能，TX端口为IOB0，RX端口为IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*****************************Usart_Send处理函数********************************
//发送一个8位数据
//===============================================================================
void Usart_Send_Byte(unsigned char Data)
{
	TX1REG = Data;
	while(!T1MCLR);
}
//===============================================================================
//********************Usart_Receive中断处理函数**********************************
//Usart1接收数据存入R_Receive_Data寄存器中
//串口接收错误数据放在R_Receive_Data_Err寄存器中
//===============================================================================
void Receive_Interrupt (void)				
{
	if(RX1IF)
	{
		if(FR1ER == 0)
		{
			R_Receive_Data = RX1REG; 
		}
		else 
		{
			R_Receive_Data_Err = RX1REG;
		}
	}
}
//===============================================================================
//********************************Usart1初始化***********************************
//Usart1异步发送和接收设置
//开启异步接收中断,分频比16,波特率为9600
//发送数据为8位，TX复用口为IOB0，RX复用口为IOB1
//===============================================================================
void Usart_INIT(void)
{
//1、设置Usart0复用口
//TX复用口为IOB0
//RX复用口为IOB1	
	MPTX1 = 0x10;
	MPRX1 = 0x11;
	ANSB0 = 0;
	ANSB1 = 0;
	OEB0 = 1;
	OEB1 = 0;
//2、Usart发送设置
	TX1CR = 0x82;
//3、波特率设置
	BRGD1H = 0x00;
	BRGD1L = 0x67;
//4、Usart接收设置
	RX1CR = 0x80;
//5、中断设置
	RX1IF = 0;
	RX1IE = 1;
	RX1IP = 0;
	GIEH = 1;
}

/*********************************END OF FILE************************************/