/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6820_WS2812.Prj
* File Name          : WS2812_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:4T,WDT-Disable-280ms,RST-IO,BOR 2.4V 
*说明：本范例点亮10个RGB灯珠并切换灯珠的三种颜色
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************LED处理程序***********************************
//===============================================================================
void WS2812_LED (void)
{
	unsigned char Led_Count;

	if(R_TC0_COUNT >= 1000)										//1s计时
	{
		for(Led_Count = 0;Led_Count < 10;Led_Count ++)			//点亮10个RGB灯
		{
			while(PWM1CR&0x04);									//LEDFLAG = 1; LED发送标志,正在发送
			PWM11DL = LEDDATA[Color_Status][0];
			while(PWM1CR&0x04);
			PWM11DL = LEDDATA[Color_Status][1];
			while(PWM1CR&0x04);
			PWM11DL = LEDDATA[Color_Status][2];
		}
		Color_Status ++;
		if(Color_Status >= 3)
		{
			Color_Status = 0;
		}
		R_TC0_COUNT = 0;
	}
}

//===============================================================================
//*******************************PWM_LED初始化***********************************
//TC1设置：递增模式，高频系统时钟，1:1分频
//PWM1配置：PWM10输出，使能级联LED驱动
//PWM1频率 = 16MHz/(19+1) = 800KHz
//PWM复用IOB0口
//===============================================================================
void PWM1_INIT(void)
{
//1、PWM设置复用口
    ANSB0 = 0;
    OEB0 = 1;
    MPPWM10 = 0x10;
//2、TC1设置
    T1CR = 0x08;
    TC1CL = 0;
    TC1CH = 0;
    TC1PR = 0x13;
//3、PWM设置
    PWM1CR = 0xC1;
    PWM10DL = 7;
    PWM10DH = 13;
    TC1EN = 1;
}
//===============================================================================
//*********************************TC0初始化*************************************
//TC0设置：8位模式，16M时钟，1:64分频
//t =计数/（时钟/分频）     1ms = （249+1）/（16/64）
//开启TC0溢出中断和总中断
//===============================================================================
void TC0_INIT(void)
{
//1、TC0设置
    T0CR = 0x2E;
    TC0CH = 0;
	TC0CL = 249;
	TC0IE = 1;
//2、中断设置
	TC0IF = 0;
	TC0EN = 1;
	TC0IP = 0;
	GIEH = 1;
}
//===============================================================================
//*********************************中断处理程序**********************************
//===============================================================================
void TC0_Interrupt (void)
{
	if(TC0IF)			//1ms
	{
		TC0IF = 0;
		R_TC0_COUNT++;
	}
}
/*********************************END OF FILE************************************/