/*******************(C) COPYRIGHT 2025 Masses-Chip *****************************
* Project Name         : M9P6362_ADC.Prj
* File Name            : ADC_Work.C
* Author			   : MASSES CHIP
* Version              : V1.05
* Date                 : 2025/08/11
* Web                  : www.masses-chip.com
* FAE                  : Luo
*                      : QQ：411680975
********************************************************************************
*-------------------------------------------------------------------------------
* 注意                 :本范例仅供参考，实际应用需评估硬件兼容性。		
*-------------------------------------------------------------------------------
* 说明:采集10次AD值,去掉最大值和最小值,对剩下的AD值求平均,结果存放在R_R_ADC_Data_Sum中
* 作为一次AD值
********************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//***********************************ADC处理*************************************
//===============================================================================
void ADC_Work(void)
{
	volatile u16 R_ADC_Outcome;
	volatile float vddVol;
	ADCON1 = 0x25;                                     //内部参考2V
	ADC_Delay16us(6);                                  //切换参考电压后建议延时至少100us	
	vddVol = GetVDD_Voltage();						   //获取VDD电压
	ADCON1 = 0x20;                                     //参考电压VDD
	ADC_Delay16us(6);                                  //切换参考电压后建议延时至少100us	
	R_ADC_Outcome = ADCDATA_AVERAGE(ADC_CHANNEL_15);   //ADC通道15采集
}
//===============================================================================
//**********************************ADC延时函数**********************************
//注意：此程序为在32MHz/8T的情况下延时16*Num (us)
//===============================================================================	
void ADC_Delay16us(unsigned char Num)
{
	volatile unsigned int i, j;
	for(i = 0;i < Num; i++)
	{
		for (j = 0; j < 5; j++);  
	}
}
//===============================================================================
//*********************************ADC通道选择函数*****************************
//ADC通道选择
//输入		adcChannel						//通道选择参数
//===============================================================================
void CHANNEL_SWITCHING(enum ADC_CHANNEL adcChannel)
{
	if ((ADCON0 & 0x1F) != adcChannel)      //检查当前通道是否不同
    {
        ADCON0 = (unsigned char)((ADCON0 & ~0x1F) | adcChannel);
		ADC_Delay16us(1);                    //切换通道后建议延时,延时时间大于一次转换时间或大于16us
    }        
}
//===============================================================================
//**********************************ADC数据采集函数******************************
//返回采集值 AD_Data
//===============================================================================
u16 ADC_CONVERTED(void)
{
	u16 AD_Data;
	ADS = 1;
	while(ADS == 1);
	AD_Data = AD;
	return AD_Data;
}
//===============================================================================
//*******************************ADC失调校准补偿函数*****************************
//ADC失调校准补偿
//返回1表示校准成功
//返回0表示校准失败
//===============================================================================	
u8 ADCSetADVOS(void)
{
	u16 R_GND_Data;
	u8 R_ADVOS_Temp;
	u8 R_ADVOS_Temp_Old;
	u8 R_ADVOS_Cnt = 0x00;
	/* 判断20次查找合适的补偿挡位 */
	for(u8 i = 0;i < 20;i++)
	{
		for(u8 val = 0; val < 16; val++)
		{
			ADCON2 = (unsigned char)((ADCON2 & ~0x0F) | val);  // 保持高位，设置低4位
			CHANNEL_SWITCHING(ADC_CHANNEL_GND);
			R_GND_Data = ADC_CONVERTED();
			if(R_GND_Data > 0x0000)
			{
				if( (ADCON2 & 0x0F) == 0)
				{
					R_ADVOS_Temp = 0;
				}
				else
				{
					R_ADVOS_Temp = (unsigned char)((ADCON2 & 0x0F) - 1);
				}
				break;						//查找到校准挡位
			}
		}
		if(R_ADVOS_Temp_Old == R_ADVOS_Temp)
		{
			R_ADVOS_Cnt++;
			if(R_ADVOS_Cnt > 3)
			{
				ADCON2 &= ~(0x0F << 0);
				ADCON2 |= R_ADVOS_Temp;
				return 1;					//连续四次得到相同结果校准成功
			}
		}
		else
		{
			R_ADVOS_Temp_Old = R_ADVOS_Temp;
			R_ADVOS_Cnt = 0x00;
		}
	}
	return 0;								//校准失败
}
//===============================================================================
//**********************************求平均函数***********************************
//采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均函数
//输入		adcChannel						//通道选择参数
//注：使用取平均函数格式需使用右对齐
//返回求的均值 R_ADC_DATA_Sum
//===============================================================================
u16 ADCDATA_AVERAGE(enum ADC_CHANNEL adcChannel)
{
	u16 R_ADC_Temp;
	u16	R_ADC_DATA_Sum = 0x0000;
	u16	R_ADC_MAX_DATA = 0x0000;
	u16	R_ADC_MIN_DATA = 0x0FFF;
	u8	i;
	CHANNEL_SWITCHING(adcChannel);
	for(i = 0;i < 10;i++)
	{
		R_ADC_Temp = ADC_CONVERTED();				
		R_ADC_DATA_Sum = R_ADC_DATA_Sum + R_ADC_Temp;
		if(R_ADC_Temp > R_ADC_MAX_DATA)
		{
			R_ADC_MAX_DATA = R_ADC_Temp;
		}
		if(R_ADC_Temp < R_ADC_MIN_DATA)
		{
			R_ADC_MIN_DATA = R_ADC_Temp;
		}	
	}
	R_ADC_DATA_Sum = R_ADC_DATA_Sum - R_ADC_MAX_DATA - R_ADC_MIN_DATA;
	R_ADC_DATA_Sum = R_ADC_DATA_Sum >> 3; 			//剩下8组数据平均
	return R_ADC_DATA_Sum;
}
//===============================================================================
//*******************************获取VDD电压函数*********************************
//获取VDD电压（前提是参考电压采用内部参考2V）
//返回求得的电压值R_vdd_Voltage
//===============================================================================	
float GetVDD_Voltage(void)
{
    float R_vdd_Voltage;
    u16 R_ADC_RES;
    R_ADC_RES = ADCDATA_AVERAGE(ADC_CHANNEL_VDD_4);
    R_vdd_Voltage =4 * 2.0 * R_ADC_RES / 4096.0;
    return R_vdd_Voltage;
}
//===============================================================================
//*********************************ADC初始化*************************************
//ADC设置：选择通道为AIN15，数据格式为右对齐
//时钟源选择为Fcpu(32M/8T)/4，内部参考2V
//ADC最大运行时钟为1MHz
//===============================================================================
void ADC_INIT(void)
{
//1、IO设置
	ANSB7 = 1;
	OEB7 = 0;
//2、ADC设置
	ADCON0 = 0xAF;
	ADCON1 = 0x25;
	ADCON2 = 0x00;
//3、ADC失调校准补偿
	ADCSetADVOS();
}
/*********************************END OF FILE************************************/