/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6362_CMP.Prj
* File Name          : CMP_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/11
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*
*Option:32M/8T,WDT-Disable-350ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例比较结果通过IOB1的高低判断
*比较器反相为外部输入IOB6，比较器正相为1/2VDD
*IOB1 = 1  负端输入电压小于正端
*IOB1 = 0  负端输入电压大于正端
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//***********************************CMP处理*************************************
//===============================================================================
void CMP_Work(void)
{
	GetCmpVDD_Voltage();									//输入VDD电压判断范围
	/*CMP比较器输入信号选择位,反相为外部输入IOB6,比较器正相为1/2VDD*/
	CMPC0 = 0xD4;
	if(CMPOUT)
	{
		IOB1 = 1;
	}
	else
	{
		IOB1 = 0;
	}
}
//===============================================================================
//*******************************VDD电压范围函数*********************************
//获取VDD电压范围,CP口选择VLD,CN口选择1/2VDD
//通过改变CMPC1里VLD的值,得到VDD的电压范围
//===============================================================================
void GetCmpVDD_Voltage(void)
{
	u8 R_CMP_VLD_Temp = 0;
	u8 R_VLD_Temp_Old = 0;
	u8 R_VLD_Cnt = 0;
	volatile float R_vdd_Vldmin = 0.00;
	volatile float R_vdd_Vldmax = 0.00;
	u8 i;	
	/* 判断20次查找对应的挡位 */
	for(i = 0;i < 20;i++)
	{
		for(CMPC1 &= ~(0x1F << 0);(CMPC1 & 0x1F) <= 0x1F;CMPC1++)
		{
		/*CMP比较器输入信号选择位,反相信号输入选择1/2VDD,正相信号输入选择VLD*/
			CMPC0 = 0xE6;
			if(CMPOUT == 1)
			{
				R_CMP_VLD_Temp = (unsigned char)(CMPC1 & 0x1F);
				break;
			}
		}
		if(R_VLD_Temp_Old == R_CMP_VLD_Temp)
		{
			R_VLD_Cnt++;
			if(R_VLD_Cnt > 3)
			{
				R_vdd_Vldmin = (1.25 + 0.05 * (R_CMP_VLD_Temp - 1) ) * 2;
				R_vdd_Vldmax = (1.25 + 0.05  * R_CMP_VLD_Temp) * 2;
			}
		}
		else
		{
			R_VLD_Temp_Old = R_CMP_VLD_Temp;
			R_VLD_Cnt = 0x00;
		}
	}
}
//===============================================================================
//*********************************CMP初始化*************************************
//CMP设置：比较器反相为外部输入IOB6，比较器正相为1/2VDD
//===============================================================================
void CMP_INIT(void)
{
//1、IO设置
	OEB6 = 0;
//2、CMP设置 
	CMPC0 = 0xD4;
	CMPC1 = 0x00;
	CMPC2 = 0x00;
}
/*********************************END OF FILE************************************/