/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6362_TC1.Prj
* File Name          : TC1_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:32M/8T,WDT-Disable-350ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例用TC1做定时器，每0.5ms翻转一次IOB1口
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************TC1处理程序***********************************
//TC1处理:主循环TC1中断标志置1,每0.5ms翻转一次IOB1口
//===============================================================================
void TC1_Work(void)
{
	if(b_TC1_Flag == 1)
	{
		b_TC1_Flag = 0;	
		IOB1 = ~IOB1;
	}
}

//===============================================================================
//******************************TC1中断处理函数**********************************
//定时器TC1每计数0.5ms，进一次中断，标志位置高
//===============================================================================
void TC1_Interrupt (void)				
{
	if(TC1IF)
	{					
		TC1IF = 0;
		b_TC1_Flag = 1;
	}
}
//===============================================================================
//*********************************TC1初始化*************************************
//TC1设置：16位模式，高频系统时钟，1:16分频
//t =计数/（时钟/分频）     0.5ms = （999+1）/（32/16）
//开启TC1溢出中断和总中断
//===============================================================================
void TC1_INIT(void)
{
//1、TC1设置
    T1CR = 0x0C; 			
    TC1CH = 0;				
    TC1CL = 0;				
	TC1PRL = 0xE7;
	TC1PRH = 0x03;
	TC1EN = 1;	
//2、高优先级中断设置 
	TC1IE = 1;
	TC1IF = 0;	
	TC1IP = 0;
	GIEH = 1;				
}
/*********************************END OF FILE************************************/