/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6362_TC2.Prj
* File Name          : TC2_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:32M/8T,WDT-Disable-350ms,RST-IO,BOR 2.4V
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例用TC2做定时器，每0.5ms翻转一次IOB1口
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************TC2处理程序***********************************
//TC2处理:主循环TC2中断标志置1,每0.5ms翻转一次IOB1口
//===============================================================================
void TC2_Work(void)
{
	if(b_TC2_Flag == 1)
	{
		b_TC2_Flag = 0;	
		IOB1 = ~IOB1;
	}
}
//===============================================================================
//******************************TC2中断处理函数**********************************
//定时器TC2每计数0.5ms，进一次中断，标志位置高
//===============================================================================
void TC2_Interrupt (void)				
{
	if(TC2IF)
	{					
		TC2IF = 0;
		b_TC2_Flag = 1;
	}
}
//===============================================================================
//*********************************TC2初始化*************************************
//TC2设置：高频系统时钟，1:16分频
//t =计数/（时钟/分频）	0.5ms = (999+1)/(32M/16)
//开启TC2溢出中断和总中断
//===============================================================================
void TC2_INIT(void)
{
//1、TC1设置
    T2CR = 0x0C; 			
    TC2CH = 0;				
    TC2CL = 0;				
	TC2PRL = 0xE7;
	TC2PRH = 0x03;
	TC2EN = 1;	
//2、高优先级中断设置 
	TC2IE = 1;
	TC2IF = 0;
	TC2IP = 0;
	GIEH = 1;				
}
/*********************************END OF FILE************************************/