/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6362_Usart1.Prj
* File Name          : Usart1_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:32M/8T,WDT-Disable-350ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为异步串口通讯，串口波特率为9600
*中断接收数据放在R_Receive_Data寄存器中
*串口接收错误数据放在R_Receive_Data_Err寄存器中
*串口端口有复用功能，TX端口为IOB0，RX端口为IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
#define	UART_BAUDRATE	9600		//波特率，支持9600及以上波特率修改
//===============================================================================
//*****************************Usart_Send处理函数********************************
//发送一个8位数据
//===============================================================================
void Usart_Send_Byte(unsigned char Data)
{
	if(b_sending_flag)
	{
		b_sending_flag = 0;
		TX1REG = Data;
		while(!T1MCLR);
	}
}
//===============================================================================
//********************Usart_Receive中断处理函数**********************************
//Usart1接收数据存入R_Receive_Data寄存器中
//串口接收错误数据放在R_Receive_Data_Err寄存器中
//===============================================================================
void Receive_Interrupt (void)				
{
	if(RX1IF)
	{
		if(FR1ER == 0)
		{
			R_Receive_Data = RX1REG; 
			b_sending_flag = 1;
		}
		else 
		{
			R_Receive_Data_Err = RX1REG;
		}
	}
}
//===============================================================================
//********************************Usart1初始化***********************************
//目标波特率 = 32M/((BRGD+1)×分频比)
//Usart1异步发送和接收设置
//开启异步接收中断,波特率为9600
//发送数据为8位，TX复用口为IOB0，RX复用口为IOB1
//===============================================================================
void Usart_INIT(void)
{
//1、设置Usart0复用口
//TX复用口为IOB0
//RX复用口为IOB1
	ANSB0 = 0;
	ANSB1 = 0;
	OEB0 = 1;
	OEB1 = 0;
	PUB1 = 1;
	MPTX1 = 0x10;
	MPRX1 = 0x11;
//2、Usart发送设置
	TX1CR = 0x80;
//3、波特率设置
	BRGD1H = ((32000000/4/UART_BAUDRATE-1)&0x0300)>>8;
	BRGD1L = ((32000000/4/UART_BAUDRATE-1)&0x00FF);
//4、Usart接收设置
	RX1CR = 0x80;
//5、中断设置
	RX1IF = 0;
	RX1IE = 1;
	RX1IP = 0;
	GIEH = 1;
}

/*********************************END OF FILE************************************/