/******************* (C) COPYRIGHT 2014~2025 MASSES CHIP ************************
* File Name          : COMMON.H
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/15
********************************************************************************
 


*******************************************************************************/
#ifndef __COMMON_H__
#define __COMMON_H__

#include "zc.h"
#include "MASSESCHIP_DEFINE.H"


void SYSTEM_INIT(void);					//系统初始化
void I2C_SLAVER_INIT(void);				//I2C初始化
void IICSLAVER_Interrupt(void);			//从机中断处理

void I2C_Slaver_Handle();//I2C从机中断处理
void STATE_SRADRACK(void);//从机接收地址应答
void STATE_SRDATACK(void);//从机接收数据应答
void STATE_SWADRACK(void);//从机发送地址应答
void STATE_SWDATACK(void);//从机发送数据应答
void SLAVER_STATE_Err(void);//状态错误
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define		STA_S_RSTART		0xA0		//从机发送重复开始或停止信号
#define		STA_S_W_ADRACK		0xA8		//从机发送地址应答
#define		STA_S_W_DATACK		0xB8		//从机发送数据应答
#define		STA_S_W_DATNACK		0xC0		//从机发送数据无应答
#define		STA_S_W_LAST		0xC8		//从机发送最后数据应答
#define		STA_S_R_ADRACK		0x60		//从机接收地址应答
#define		STA_S_R_DATACK		0x80		//从机接收数据应答
#define		STA_S_R_ADRNACK		0x88		//从机接收地址无应答
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
bit B_I2C_Flag;									//IIC通讯标志
u8 I2C_SLAVER_DATA[15] __at(0x40) = {0};		//定义存放主机向从机读写的数据的数组及其地址
u8 R_Data_Num = 0;



#endif

/*********************************END OF FILE************************************/
