/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6363_IO_Interrupt.Prj
* File Name          : IO_Interrupt_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:8T,WDT-Disable,RST-IO,BOR 2.4V 
*说明：本范例为若产生IOC0中断，则唤醒休眠，翻转IOC1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************端口变化中断主函数****************************
//IO变化中断产生时翻转IOC1口
//进休眠
//===============================================================================
void IO_Interrupt_Work(void)					  		//程序主函数
{
	if(b_IO_Interrupt_Flag)
	{
		b_IO_Interrupt_Flag = 0;
		IOC1 = ~IOC1;
	}
	STOP = 1;
	NOP();
	NOP();
	NOP();
}

//===============================================================================
//**********************************端口中断处理函数*****************************
//IO变化中断，进一次中断，标志位置高
//===============================================================================
void IO_Interrupt(void)
{
	if(IOCCHIF)
	{
		IOCCHIF = 0;
		b_IO_Interrupt_Flag = 1;
	}
}
//===============================================================================
//*********************************IOC中断初始化*********************************
//IOC0设置为输入下拉，开启IOC0变化中断
//开启芯片休眠模式
//===============================================================================
void IOC_Interrupt_INIT(void)
{
//1、设置IO口
	OEC0 = 0;
	PUC0 = 1;
	ANSC0 = 0;
//2、开启IOB中断
	IOCICR = 0x01;
	IOCCHIE = 1;
	IOCCHIF = 0;
	IOCCHIP = 0;			//设置高优先级
	GIEH = 1;
}
/*********************************END OF FILE************************************/