/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9P6363_PWM0.Prj
* File Name          : PWM0_Work.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/08/15
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例使用PWM0x输出1KHz占空比为50%的方波
*方波循环开启50ms,关闭50ms
*PWM00复用口为C0
*PWM01复用口为C1
*PWM02复用口为C2
*PWM03复用口为C3
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void PWM0_Work(void)
{
	PWM00OE = 1;
	PWM01OE = 1;
	PWM02OE = 1;
	PWM03OE = 1;	
	Delay_50ms();
	PWM00OE = 0;
	PWM01OE = 0;
	PWM02OE = 0;
	PWM03OE = 0;		
	Delay_50ms();
}

//===============================================================================
//*********************************延时50ms**************************************
//延时50ms/8T下
//===============================================================================
void Delay_50ms(void)
{
	u8 R_Delay_Count;
	u8 R_Delay_Count_1;
	for(R_Delay_Count_1 = 200;R_Delay_Count_1 > 0;R_Delay_Count_1--)
	{
		for(R_Delay_Count = 250;R_Delay_Count > 0;R_Delay_Count--);	
	}
}
//===============================================================================
//*********************************PWM0初始化*************************************
//TC0设置：8位模式，高频系统时钟，1:128分频
//PWM0配置，独立输出 PWM0x输出1KHz占空比为50%的方波
//===============================================================================
void PWM0_INIT(void)
{
//1、PWM0输出口设置
//PWM00复用口为C0
//PWM01复用口为C1
//PWM02复用口为C2
//PWM03复用口为C3
	ANSC0 = 0;
	ANSC1 = 0;
	ANSC2 = 0;
	ANSC3 = 0;
	OEC0 = 1;
	OEC1 = 1;
	OEC2 = 1;
	OEC3 = 1;
	MPPWM0 = 0x20;
//2、TC0设置	
	T0CR = 0x0F;
	TC0CL = 249;
	TC0CH = 0;
	TC0EN = 1;
//3、PWM0设置 
	PWM00CR = 0x80;
	PWM01CR = 0x80;
	PWM02CR = 0x80;
	PWM03CR = 0x80;	
	PWM00D = 125;
	PWM01D = 125;
	PWM02D = 125;
	PWM03D = 125;
}
/*********************************END OF FILE************************************/