/*******************(C) COPYRIGHT 2023 Masses-Chip ******************************
* File Name          : M9F_IO_INIT.h
* Author             : MASSES CHIP
* Version            : V2.02
* Date               : 2023/05/17
*********************************************************************************



********************************************************************************/
#ifndef __M9F_IO_INIT_H__
#define __M9F_IO_INIT_H__

//===============================================================================
//  port_num = A/B/C/...
//  pin_num = 0~7

#define SET_ANALOG_EN(port_num,pin_num)         (ANS##port_num##pin_num = 1)  //打开对应端口模拟功能
#define SET_ANALOG_DIS(port_num,pin_num)        (ANS##port_num##pin_num = 0)  //关闭对应端口模拟功能

#define SET_PORT_IN(port_num,pin_num)           (OE##port_num##pin_num = 0)   //对应端口设为输入口 注：必须关闭对应端口模拟功能才能读取端口状态

#define SET_PORT_PU(port_num,pin_num)           ((PU##port_num##pin_num) = 1) //打开对应端口上拉
#define SET_PORT_PU_EN(port_num,pin_num)        ((PU##port_num##pin_num) = 1) //打开对应端口上拉  
#define SET_PORT_PU_DIS(port_num,pin_num)       ((PU##port_num##pin_num) = 0) //关闭对应端口上拉

#define SET_PORT_PD(port_num,pin_num)           ((PD##port_num##pin_num) = 1) //打开对应端口下拉
#define SET_PORT_PD_EN(port_num,pin_num)        ((PD##port_num##pin_num) = 1) //打开对应端口下拉
#define SET_PORT_PD_DIS(port_num,pin_num)       ((PD##port_num##pin_num) = 0) //关闭对应端口下拉

//  p_data 对应端口输出值0/1
#define SET_aPORT_OUT(port_num,pin_num,p_data)  (IO##port_num##pin_num = p_data,OE##port_num##pin_num = 1) //对应端口设为输出且输出p_data设定值

#endif /* __M9F_IO_INIT_H__ */
